from django.contrib import admin

from account.models import Profile


@admin.register(Profile)
class ProfileAdmin(admin.ModelAdmin):

    def refs(self, obj):
        return obj.recomended_by

    refs.short_description = "Referee"

    list_display = ['user','country' ,'refs']
