import random
import string
import random
from .models import OTP


def generate_ref_code():
    letters = string.ascii_lowercase
    code= ''.join(random.choice(letters) for i in range(6))
    return code



def generate_otp(user):
    otp_code = f"{random.randint(100000, 999999)}"
    otp, created = OTP.objects.update_or_create(user=user, defaults={'otp': otp_code})
    return otp_code


def verify_otp(user, otp_code):
    try:
        otp = OTP.objects.get(user=user, otp=otp_code)
        if otp.is_expired():
            return False
        return True
    except OTP.DoesNotExist:
        return False