from django.conf.urls import include
from django.urls import path
from django.conf.urls.static import static
from django.conf import settings
from .views import ActivateAccountView, activation_sent, getRecProfile, otp_verify_view, signup, update_2fa_status, user_login, profile


app_name = "account"
urlpatterns = [
    path('profile/', profile, name='profile'),
    path('login/', user_login, name='login'),
    path('update-2fa/', update_2fa_status, name='update_2fa_status'),
    path('otp-verify/', otp_verify_view, name='otp_verify'),
    path('mylink/<str:ref_code>/', getRecProfile, name='get_profile'),
    path('sign-up/', signup, name="signup"),
    path('sent/', activation_sent, name="activation_sent"),
    path('activate/<slug:uidb64>/<slug:token>/', ActivateAccountView.as_view(), name='activate'),
    path('', include('django.contrib.auth.urls')),
]
