from decimal import Decimal
from django.contrib import admin
from core.models import InvestmentType, Profit, Transaction
from mailer.sender import send_html_email
# Register your models here.
from tradewise.settings import EMAIL_HOST_USER as admin_mail
# from tradewise.setting import ADMIN_MAIL
from mailer.sender import send_html_email
ADMIN_MAIL = "intercapitastock@gmail.com"
ADMIN_USER = ADMIN_MAIL


def withdraw_sent(modeladmin, request, queryset):
    data = set(queryset)
    print(data)
    for query in data:
        amount = Decimal(query.amount)
        user = query.user
        pro = user.userprofit
        if query.updated_investment_type == "crypto_pro":
            pro.crypto_pro -= amount

        elif query.updated_investment_type == "stock_trader":
            pro.stock_trader -= amount

        elif query.updated_investment_type == "all_in_one":
            pro.all_in_one -= amount

        pro.save()
    queryset.update(sent=True)


withdraw_sent.short_description = "Confirm All Pending Withdrawal"

def deposit_receive(modeladmin, request, queryset):
    queryset.update(recieved=True)
    for query in queryset:
        send_html_email('emails/emailDeposit.html','InterCapitaStock Deposit', admin_mail, to_emails=[query.user.email], context={"user":query.user, "transaction":query, "investment_type":query.updated_investment_type, "currency":query.currency, "address":query.address_deposit,})

deposit_receive.short_description = "Confirm All Pending Deposit"


@admin.register(Transaction)
class TransactionAdmin(admin.ModelAdmin):
    list_display = [
        'user',
        'tid',
        'amount',
        'updated_investment_type',
        'transaction_type',
        'sent',
        'time',
        'recieved'
    ]

    list_filter = [
        'investment_type',
        'transaction_type',
        'sent',
        'recieved'
    ]

    search_fields = [
        'user__username',
        'user__email',
        "user__first_name",
        "user__last_name",
        'tid',
    ]

    actions = [
        withdraw_sent,
        deposit_receive
    ]



@admin.register(Profit)
class Profit(admin.ModelAdmin):
    list_display = [
        'user',
        'crypto_pro',
        'stock_trader',
        'all_in_one',
        'can_withdraw'
    ]


@admin.register(InvestmentType)
class InvestmmentType(admin.ModelAdmin):
    list_display = [
        'user',
        'investment_type',
    ]
