# Generated by Django 5.0.1 on 2024-02-05 00:21

from django.db import migrations, models


def populate_updated_investment_type(apps, schema_editor):
    Transaction = apps.get_model('your_app_name', 'Transaction')
    for transaction in Transaction.objects.all():
        print(transaction.investment_type)
        if transaction.investment_type == 'LONG':
            transaction.updated_investment_type = 'crypto_pro'
        elif transaction.investment_type == 'SHORT':
            transaction.updated_investment_type = 'stock_trader'
        transaction.save()

class Migration(migrations.Migration):
    dependencies = [
        ("core", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="transaction",
            name="updated_investment_type",
            field=models.CharField(
                choices=[
                    ("crypto_pro", "Crypto Pro Account"),
                    ("stock_trader", "Stock Trader Account"),
                    ("all_in_one", "All In One Account"),
                ],
                default="crypto_pro",
                max_length=20,
            ),
        ),
        migrations.RunPython(populate_updated_investment_type),
    ]
