from django.db import models
from django.conf import settings
from .myutils import generate_ref_code, get_uuid
from django.db.models import Sum

# Create your models here.

class Transaction(models.Model):
    INVESTMENT_TYPE = (
        ('LONG', "Long"),
        ('SHORT', "Short"),
    )
    TRANSACTION_TYPE = (
        ("DEPOSIT", "Deposit"),
        ("WITHDRAW", "Withdraw")
    )
    UPDATED_INVESTMENT_TYPE = (
        ('crypto_pro', "Crypto Pro Account"),
        ('stock_trader', "Stock Trader Account"),
        ('all_in_one', "All In One Account"),
    )

    updated_investment_type = models.CharField(max_length=20, default="crypto_pro", choices=UPDATED_INVESTMENT_TYPE)
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)
    investment_type = models.CharField(max_length=20, default="SHORT", choices=INVESTMENT_TYPE)
    transaction_type = models.CharField(max_length=20, choices=TRANSACTION_TYPE ,default="DEPOSIT")
    amount = models.FloatField(default=0)
    wallet_add = models.CharField(max_length=200, blank=True, null=True)
    wallet_type = models.CharField(max_length=10, blank=True, null=True)
    sent = models.BooleanField(default=False)
    recieved = models.BooleanField(default=False)
    time = models.DateTimeField(auto_now=True)
    tid = models.CharField(max_length=50)
    currency = models.CharField(max_length=100, blank=True, null=True)
    address_deposit = models.CharField(max_length=100, blank=True, null=True)

    def __str__(self):
        return f"{self.user} made {self.investment_type} of {self.amount}"

    @classmethod
    def getAllDeposit(self, user):
        total = Transaction.objects.filter(user=user, transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0
    @classmethod
    def getLong(self, user):
        total = Transaction.objects.filter(user=user, investment_type="LONG", transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0
    @classmethod
    def getShort(self, user):
        total = Transaction.objects.filter(user=user, investment_type="SHORT", transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0

    @classmethod
    def getCryptoPro(self, user):
        total = Transaction.objects.filter(user=user, updated_investment_type="crypto_pro", transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0

    @classmethod
    def getStockTrader(self, user):
        total = Transaction.objects.filter(user=user, updated_investment_type="stock_trader", transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0

    @classmethod
    def getAllInOne(self, user):
        total = Transaction.objects.filter(user=user, updated_investment_type="all_in_one", transaction_type="DEPOSIT", recieved=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0

    @classmethod
    def getAllWithdraws(self, user):
        total = Transaction.objects.filter(user=user, transaction_type="WITHDRAW", sent=True).aggregate(Sum('amount'))
        return total['amount__sum'] if total['amount__sum'] else 0 

    def save(self, *args, **kwargs):
        self.tid = get_uuid()[:12]
        super().save(*args, **kwargs)


class Profit(models.Model):
    user = models.OneToOneField(settings.AUTH_USER_MODEL, on_delete=models.CASCADE, related_name="userprofit")
    amount = models.FloatField(default=0)
    ref_bonus = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)

    stock_trader = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)
    stock_trader_started = models.BooleanField(default=False)

    crypto_pro = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)
    crypto_pro_started = models.BooleanField(default=False)

    all_in_one = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)
    all_in_one_started = models.BooleanField(default=False)


    can_withdraw = models.BooleanField(default=False)

    def get_total_profit(self):
        return self.crypto_pro + self.stock_trader + self.all_in_one

    def __str__(self):
        return f"{self.user} gained {self.amount}"




class InvestmentType(models.Model):
    INVESTMENT_TYPE = (
        ('crypto_pro', "Crypto Pro Account"),
        ('stock_trader', "Stock Trader Account"),
        ('all_in_one', "All In One Account"),
    )
    user = models.ForeignKey(settings.AUTH_USER_MODEL, on_delete=models.CASCADE)
    investment_type = models.CharField(max_length=20, default="crypto_pro", choices=INVESTMENT_TYPE)