from django.urls import path
from . import views

app_name="core"

urlpatterns = [
    path("", views.home, name="home"),
    path("market", views.market, name="market"),

    # ACCOUNTS
    path("trading/platform/", views.platform, name="platform"),

    path("trading/our-accounts/", views.our_account, name="our_account"),

    path("trading/crypto-accounts/", views.crypto_account, name="crypto_account"),

    path("trading/all-in-one-accounts/", views.all_in_one_account, name="all_in_one_account"),

    path("trading/stock-trading-accounts/", views.stock_trader_account, name="stock_trader_account"),

    path('send-otp/', views.send_otp_view, name='send_otp'),

    # ABOUT
    path("about/company/", views.company, name="company"),
    path("about/contact/", views.contact, name="contact"),
    path("about/faq/", views.faq, name="faq"),

    #DASHBOARD
    path("dashboard/", views.dashboard, name="dashboard"),
    path("dashboard/settings/", views.settings, name="settings"),
    path("dashboard/accounts/", views.accounts, name="accounts"),
    path("dashboard/history/", views.history, name="history"),
]
